<?php
/*
Template Name: Blog Corporate 2
*/

get_header('custom'); ?>

<section class="container-padding top-section">
    <div class="container">
        <div class="row">
            <div class="col">
            
            
<?php 
$template_title = the_title();
$template_uri = parse_url(get_the_permalink(), PHP_URL_PATH);
$categories = '1'; // use negative to exclude
query_posts('post_type=post&post_status=publish&posts_per_page=2&cat='.$categories.'&paged='. get_query_var('paged'));

if (have_posts()) :
  $post_count = 0;
  $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
  while (have_posts()) :

    the_post();
    $thumb_url = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );

    if( $thumb_url ) {
        $has_thumb = true;
        $thumb_class = 'has-thumbnail';
        $thumb_style = 'background-image: url(' . $thumb_url . ');';
    } else {
        $has_thumb = false;
        $thumb_class = '';
        $thumb_style = '';
	}

    $post_count++;
    if( $post_count == 1 ) :
      if( $paged == 1 ) : ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class( 'the-latest ' . $thumb_class ); ?> role="article">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <strong>Latest post</strong>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <h2><?php the_title(); ?></h2>
                        <?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=230&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?>
                    </div>
                </div>
            </div>
        </article> <!-- end .the-latest -->
      <?php else : ?>

        <header class="page-header">
            <div class="container">
                <div id="content" class="clearfix row">
                    <div class="col-sm-9">
                        <h1><a href="<?php echo $template_uri; ?>" rel="bookmark" title="<?php echo $template_title; ?>"><?php echo $template_title; ?></a></h1>
                    </div>
                </div>
            </div>
        </header>

      <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<section class="container-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 col-md-9 col-sm-8 col-xs-12 articles">
                <?php else : ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class( 'clearfix ' . $thumb_class ); ?> role="article">

                    <h1><a href="<?php echo the_permalink() ?>" rel="bookmark" title="<?php echo the_title_attribute(); ?>"><?php echo the_title(); ?></a></h1>


                </article> <!-- end article -->
                <?php endif; endwhile; ?>
            </div> <!-- end .col-sm-9 -->

            <div class="col-lg-3 col-md-3 col-sm-4 col-xs-12">
              This is a sidebar
            </div>
            
            
            
            
            <div class="col-lg-9 col-md-9 col-sm-8 col-xs-12 page-navigation">
            <?php if (function_exists('wp_bootstrap_page_navi')) { // if expirimental feature is active
                  wp_bootstrap_page_navi(); // use the page navi function
              } else { // if it is disabled, display regular wp prev & next links
            ?>

            <?php the_posts_pagination(  ); ?> 

            <?php } ?>
            </div>

        </div>
    </div>
</section>

<?php else : ?>

<div class="container">
	<article id="post-not-found" class="row">
		<header>
			<h1><?php _e("Not Found", "wpbootstrap"); ?></h1>
		</header>
		<section class="post_content">
			<p><?php _e("Sorry, but the requested resource was not found on this site.",
				"wpbootstrap"); ?></p>
			<div class="row">
				<div class="col col-lg-12">
					<?php get_search_form(); ?>
				</div>
			</div>
		</section>
		<footer></footer>
	</article>
</div>
                
                

<?php endif; ?>
                
          


<?php get_footer('custom'); ?>
